/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueVisitor;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.Calendar;

public class NodeValueDateTime
extends NodeValue {
    Calendar date;

    public NodeValueDateTime(Calendar cal) {
        this.date = cal;
    }

    public NodeValueDateTime(Calendar cal, Node n) {
        super(n);
        this.date = cal;
    }

    public boolean isDateTime() {
        return true;
    }

    public Calendar getDateTime() {
        return this.date;
    }

    protected Node makeNode() {
        String lex = Utils.calendarToXSDDateTimeString(this.date);
        return Node.createLiteral((String)lex, null, (RDFDatatype)XSDDatatype.XSDdateTime);
    }

    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

