/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify.lang;

import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.modify.lang.parser.ParseException;
import com.hp.hpl.jena.sparql.modify.lang.parser.SPARULParser;
import com.hp.hpl.jena.sparql.modify.lang.parser.TokenMgrError;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.StringReader;
import org.apache.commons.logging.LogFactory;

public class ParserSPARUL {
    public UpdateRequest parse(UpdateRequest update, String queryString) {
        SPARULParser parser = null;
        StringReader in = new StringReader(queryString);
        try {
            parser = new SPARULParser(in);
            parser.setUpdateRequest(update);
            parser.SPARUL();
            return update;
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new QueryParseException(tErr.getMessage(), line, col);
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Error err) {
            throw new QueryParseException(err.getMessage(), err, -1, -1);
        }
        catch (Throwable th) {
            LogFactory.getLog(this.getClass()).fatal((Object)"Unexpected throwable: ", th);
            throw new QueryException(th.getMessage(), th);
        }
    }
}

