/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.resultset.JSONResults;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import com.hp.hpl.jena.sparql.util.GraphUtils;
import com.hp.hpl.jena.sparql.util.LabelToNodeMap;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import com.hp.hpl.jena.sparql.util.RefBoolean;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONInput
extends SPARQLResult {
    static /* synthetic */ Class class$com$hp$hpl$jena$sparql$resultset$JSONInput$JSONResultSet;

    public JSONInput(InputStream in) {
        this(in, null);
    }

    public JSONInput(InputStream in, Model model) {
        JSONObject obj;
        JSONResultSet r;
        if (model == null) {
            model = GraphUtils.makeJenaDefaultModel();
        }
        if ((r = new JSONResultSet(obj = JSONInput.toJSON(in), model)).isResultSet()) {
            this.set(r);
        } else {
            this.set(r.askResult);
        }
    }

    public static ResultSet fromJSON(InputStream in) {
        return JSONInput.fromJSON(in, null);
    }

    public static ResultSet fromJSON(InputStream in, Model model) {
        JSONInput jin = new JSONInput(in, model);
        if (jin.isResultSet()) {
            return jin.getResultSet();
        }
        throw new ResultSetException("Not a result set");
    }

    public static boolean booleanFromXML(InputStream in) {
        JSONInput jin = new JSONInput(in, null);
        if (!jin.isResultSet()) {
            return jin.getBooleanResult();
        }
        throw new ResultSetException("Not a boolean result");
    }

    public static SPARQLResult make(InputStream in, Model model) {
        return new JSONInput(in, model);
    }

    private static JSONObject toJSON(InputStream in) {
        try {
            String s = FileUtils.readWholeFileAsUTF8((InputStream)in);
            JSONObject json = new JSONObject(s);
            return json;
        }
        catch (JSONException e2) {
            throw new ResultSetException(e2.getMessage(), e2);
        }
        catch (IOException e3) {
            throw new ResultSetException(e3.getMessage(), e3);
        }
    }

    public static class JSONResultSet
    implements ResultSet,
    JSONResults {
        QuerySolution current = null;
        List variables = new ArrayList();
        Binding binding = null;
        RefBoolean inputGraphLabels = new RefBoolean(ARQ.inputGraphBNodeLabels, false);
        LabelToNodeMap bNodes = LabelToNodeMap.createBNodeMap();
        boolean isResultSet = false;
        boolean ordered = false;
        boolean distinct = false;
        boolean finished = false;
        Model model = null;
        int row = 0;
        boolean askResult = false;
        JSONObject json = null;

        JSONResultSet(JSONObject json) {
            this(json, null);
        }

        JSONResultSet(JSONObject json, Model model) {
            this.json = json;
            this.model = model;
            this.init();
        }

        public boolean isResultSet() {
            return this.isResultSet;
        }

        public boolean getBooleanResult() {
            if (this.isResultSet()) {
                throw new ResultSetException("Not a boolean result");
            }
            return this.askResult;
        }

        private void init() {
            this.processHead();
            if (this.json.has("results")) {
                this.isResultSet = true;
                this.processResults();
            }
            if (this.json.has("boolean")) {
                this.isResultSet = false;
                this.processBoolean();
            }
        }

        public boolean hasNext() {
            if (!this.isResultSet) {
                throw new ResultSetException("Not an XML result set");
            }
            if (this.finished) {
                return false;
            }
            if (this.binding == null) {
                this.binding = this.getOneSolution();
                ++this.row;
            }
            return this.binding != null;
        }

        public Object next() {
            return this.nextSolution();
        }

        public QuerySolution nextSolution() {
            if (this.finished) {
                throw new NoSuchElementException("End of JSON Results");
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException("End of JSON Results");
            }
            ResultBinding currentEnv = new ResultBinding(this.model, this.binding);
            this.binding = null;
            return currentEnv;
        }

        public int getRowNumber() {
            return this.row;
        }

        public List getResultVars() {
            return this.variables;
        }

        public boolean isOrdered() {
            return this.ordered;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        public void remove() {
            throw new UnsupportedOperationException((class$com$hp$hpl$jena$sparql$resultset$JSONInput$JSONResultSet == null ? (class$com$hp$hpl$jena$sparql$resultset$JSONInput$JSONResultSet = JSONInput.class$("com.hp.hpl.jena.sparql.resultset.JSONInput$JSONResultSet")) : class$com$hp$hpl$jena$sparql$resultset$JSONInput$JSONResultSet).getName());
        }

        private void processBoolean() {
            try {
                this.askResult = this.json.getBoolean("boolean");
            }
            catch (JSONException e2) {
                throw new ResultSetException("Unknown boolean value.");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void processHead() {
            try {
                if (!this.json.has("head")) {
                    return;
                }
                JSONObject head = this.json.getJSONObject("head");
                if (head.has("vars")) {
                    JSONArray vars = head.getJSONArray("vars");
                    for (int i = 0; i < vars.length(); ++i) {
                        this.variables.add(vars.getString(i));
                    }
                }
                if (!head.has("link")) return;
            }
            catch (JSONException e2) {
                throw new ResultSetException(e2.getMessage(), e2);
            }
        }

        private void processResults() {
        }

        private Binding getOneSolution() {
            try {
                JSONObject jresults = this.json.getJSONObject("results");
                JSONArray jbindings = jresults.getJSONArray("bindings");
                if (this.row < 0 || this.row >= jbindings.length()) {
                    return null;
                }
                BindingMap binding = new BindingMap();
                JSONObject jsolution = jbindings.getJSONObject(this.row);
                Iterator it = jsolution.keys();
                while (it.hasNext()) {
                    Node node;
                    String varName = (String)it.next();
                    JSONObject jbinding = jsolution.getJSONObject(varName);
                    if (!jbinding.has("type")) {
                        throw new ResultSetException("Binding is missing 'type'.");
                    }
                    if (jbinding.getString("type").equals("uri")) {
                        String uri = jbinding.getString("value");
                        node = Node.createURI((String)uri);
                        binding.add(Var.alloc(varName), node);
                    }
                    if (jbinding.getString("type").equals("bnode")) {
                        String label = jbinding.getString("value");
                        node = null;
                        node = this.inputGraphLabels.getValue() ? Node.createAnon((AnonId)new AnonId(label)) : this.bNodes.asNode(label);
                        binding.add(Var.alloc(varName), node);
                    }
                    if (!jbinding.getString("type").equals("literal") && !jbinding.getString("type").equals("typed-literal")) continue;
                    String lex = jbinding.getString("value");
                    String lang = jbinding.optString("xml:lang");
                    String dtype = jbinding.optString("datatype");
                    Node n = NodeUtils.createLiteralNode(lex, lang, dtype);
                    binding.add(Var.alloc(varName), n);
                }
                return binding;
            }
            catch (JSONException e2) {
                throw new ResultSetException(e2.getMessage(), e2);
            }
        }
    }
}

