/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.resultset.JSONResults;
import com.hp.hpl.jena.sparql.resultset.ResultSetProcessor;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class JSONOutputResultSet
implements ResultSetProcessor,
JSONResults {
    static boolean multiLineValues = false;
    static boolean multiLineVarNames = false;
    static IndentedWriter out;
    int bNodeCounter = 0;
    Map bNodeMap = new HashMap();
    boolean firstSolution = true;
    boolean firstBindingInSolution = true;

    JSONOutputResultSet(OutputStream outStream) {
        this(new IndentedWriter(outStream));
    }

    JSONOutputResultSet(IndentedWriter indentedOut) {
        out = indentedOut;
    }

    public void start(ResultSet rs) {
        out.println("{");
        out.incIndent();
        this.doHead(rs);
        out.println(JSONOutputResultSet.quoteName("results") + ": {");
        out.incIndent();
        out.println(JSONOutputResultSet.quoteName("bindings") + ": [");
        out.incIndent();
        this.firstSolution = true;
    }

    public void finish(ResultSet rs) {
        out.println();
        out.decIndent();
        out.println("]");
        out.decIndent();
        out.println("}");
        out.decIndent();
        out.println("}");
        out.flush();
    }

    private void doHead(ResultSet rs) {
        out.println(JSONOutputResultSet.quoteName("head") + ": {");
        out.incIndent();
        this.doLink(rs);
        this.doVars(rs);
        out.decIndent();
        out.println("} ,");
    }

    private void doLink(ResultSet rs) {
    }

    private void doVars(ResultSet rs) {
        out.print(JSONOutputResultSet.quoteName("vars") + ": [ ");
        if (multiLineVarNames) {
            out.println();
        }
        out.incIndent();
        Iterator iter = rs.getResultVars().iterator();
        while (iter.hasNext()) {
            String varname = (String)iter.next();
            out.print("\"" + varname + "\"");
            if (multiLineVarNames) {
                out.println();
            }
            if (!iter.hasNext()) continue;
            out.print(" , ");
        }
        out.println(" ]");
        out.decIndent();
    }

    public void start(QuerySolution qs) {
        if (!this.firstSolution) {
            out.println(" ,");
        }
        this.firstSolution = false;
        out.println("{");
        out.incIndent();
        this.firstBindingInSolution = true;
    }

    public void finish(QuerySolution qs) {
        out.println();
        out.decIndent();
        out.print("}");
    }

    public void binding(String varName, RDFNode value) {
        if (value == null) {
            return;
        }
        if (!this.firstBindingInSolution) {
            out.println(" ,");
        }
        this.firstBindingInSolution = false;
        out.print(JSONOutputResultSet.quote(varName) + ": { ");
        if (multiLineValues) {
            out.println();
        }
        out.incIndent();
        if (value == null) {
            this.printUnbound();
        } else if (value.isLiteral()) {
            this.printLiteral((Literal)value);
        } else if (value.isResource()) {
            this.printResource((Resource)value);
        } else {
            LogFactory.getLog(this.getClass()).warn((Object)("Unknown RDFNode type in result set: " + value.getClass()));
        }
        out.decIndent();
        if (!multiLineValues) {
            out.print(" ");
        }
        out.print("}");
    }

    private void printUnbound() {
        out.print(JSONOutputResultSet.quoteName("type") + ": " + JSONOutputResultSet.quote("unbound") + " , ");
        if (multiLineValues) {
            out.println();
        }
        out.print(JSONOutputResultSet.quoteName("value") + ": null");
        if (multiLineValues) {
            out.println();
        }
    }

    private void printLiteral(Literal literal) {
        String datatype = literal.getDatatypeURI();
        String lang = literal.getLanguage();
        if (datatype != null) {
            out.print(JSONOutputResultSet.quoteName("datatype") + ": " + JSONOutputResultSet.quote(datatype) + " , ");
            if (multiLineValues) {
                out.println();
            }
            out.print(JSONOutputResultSet.quoteName("type") + ": " + JSONOutputResultSet.quote("typed-literal") + " , ");
            if (multiLineValues) {
                out.println();
            }
        } else {
            out.print(JSONOutputResultSet.quoteName("type") + ": " + JSONOutputResultSet.quote("literal") + " , ");
            if (multiLineValues) {
                out.println();
            }
            if (lang != null && !lang.equals("")) {
                out.print(JSONOutputResultSet.quoteName("xml:lang") + ": " + JSONOutputResultSet.quote(lang) + " , ");
                if (multiLineValues) {
                    out.println();
                }
            }
        }
        out.print(JSONOutputResultSet.quoteName("value") + ": " + JSONOutputResultSet.quote(literal.getLexicalForm()));
        if (multiLineValues) {
            out.println();
        }
    }

    private void printResource(Resource resource) {
        if (resource.isAnon()) {
            out.print(JSONOutputResultSet.quoteName("type") + ": " + JSONOutputResultSet.quote("bnode") + " , ");
            if (multiLineValues) {
                out.println();
            }
            if (!this.bNodeMap.containsKey(resource)) {
                this.bNodeMap.put(resource, "b" + this.bNodeCounter++);
            }
            String label = (String)this.bNodeMap.get(resource);
            out.print(JSONOutputResultSet.quoteName("value") + ": " + JSONOutputResultSet.quote(label));
            if (multiLineValues) {
                out.println();
            }
        } else {
            out.print(JSONOutputResultSet.quoteName("type") + ": " + JSONOutputResultSet.quote("uri") + " , ");
            if (multiLineValues) {
                out.println();
            }
            out.print(JSONOutputResultSet.quoteName("value") + ": " + JSONOutputResultSet.quote(resource.getURI()));
            if (multiLineValues) {
                out.println();
            }
            return;
        }
    }

    private static String quote(String string) {
        return JSONObject.quote((String)string);
    }

    private static String quoteName(String string) {
        return JSONOutputResultSet.quote(string);
    }
}

