/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprFunction1;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.NodeVar;
import com.hp.hpl.jena.sparql.serializer.FmtExpr;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;

public class FmtExprARQ
extends FmtExpr {
    IndentedWriter out;
    SerializationContext context;

    public FmtExprARQ(IndentedWriter writer, PrefixMapping pmap) {
        this(writer, new SerializationContext(pmap, null));
    }

    public FmtExprARQ(IndentedWriter writer, SerializationContext cxt) {
        this.out = writer;
        this.context = cxt;
        if (this.context == null) {
            this.context = new SerializationContext();
        }
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Expr expr) {
        FmtExprARQ fmt = new FmtExprARQ(out, cxt);
        fmt.startVisit();
        expr.visit(fmt);
        fmt.finishVisit();
    }

    public void startVisit() {
    }

    private void visitFunction1(ExprFunction1 expr) {
        this.out.print("( ");
        this.out.print(expr.getOpName());
        this.out.print(" ");
        expr.getArg().visit(this);
        this.out.print(" )");
    }

    private void visitFunction2(ExprFunction2 expr) {
        this.out.print("( ");
        expr.getArg1().visit(this);
        this.out.print(" ");
        this.out.print(expr.getOpName());
        this.out.print(" ");
        expr.getArg2().visit(this);
        this.out.print(" )");
    }

    public void visit(ExprFunction func) {
        Expr expr;
        if (func.getOpName() != null && func instanceof ExprFunction2) {
            this.visitFunction2((ExprFunction2)func);
            return;
        }
        if (func.getOpName() != null && func instanceof ExprFunction1) {
            this.visitFunction1((ExprFunction1)func);
            return;
        }
        this.out.print(func.getFunctionPrintName(this.context));
        this.out.print("(");
        int i = 1;
        while ((expr = func.getArg(i)) != null) {
            if (i != 1) {
                this.out.print(", ");
            }
            expr.visit(this);
            ++i;
        }
        this.out.print(")");
    }

    public void visit(NodeValue nv) {
        this.out.print(nv.asQuotedString(this.context));
    }

    public void visit(NodeVar nv) {
        String s = nv.getVarName();
        if (Var.isBlankNodeVarName(s)) {
            Var v = Var.alloc(s);
            this.out.print(this.context.getBNodeMap().asString((Node)v));
        } else {
            this.out.print("?");
            this.out.print(nv.getVarName());
        }
    }

    public void finishVisit() {
        this.out.flush();
    }
}

