/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.serializer.FmtExprPrefix;
import com.hp.hpl.jena.sparql.serializer.FormatterBase;
import com.hp.hpl.jena.sparql.serializer.FormatterElement;
import com.hp.hpl.jena.sparql.serializer.FormatterTemplate;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementDataset;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.syntax.ElementUnsaid;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.syntax.TemplateGroup;
import com.hp.hpl.jena.sparql.syntax.TemplateTriple;
import com.hp.hpl.jena.sparql.util.IndentedLineBuffer;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.util.Iterator;
import java.util.ListIterator;

public class FormatterPlain
extends FormatterBase
implements FormatterElement,
FormatterTemplate {
    static int INDENT = 2;

    public FormatterPlain(IndentedWriter out, SerializationContext context) {
        super(out, context);
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Element el) {
        FormatterPlain fmt = new FormatterPlain(out, cxt);
        fmt.startVisit();
        el.visit(fmt);
        fmt.finishVisit();
    }

    public static String asString(Element el) {
        SerializationContext cxt = new SerializationContext();
        IndentedLineBuffer b = new IndentedLineBuffer();
        FormatterPlain.format(b.getIndentedWriter(), cxt, el);
        return b.toString();
    }

    public boolean topMustBeGroup() {
        return false;
    }

    private void format(Triple t) {
        this.out.print("TriplePattern");
        this.out.print(" ");
        this.formatTriple(t);
    }

    public void visit(ElementTriplesBlock el) {
        this.out.print("BasicGraphPattern");
        this.out.incIndent(INDENT);
        ListIterator iter = el.getTriples().iterator();
        while (iter.hasNext()) {
            this.out.newline();
            Triple t = (Triple)iter.next();
            this.format(t);
        }
        this.out.decIndent(INDENT);
    }

    public void visit(ElementDataset el) {
        this.out.print("Block");
        this.out.incIndent(INDENT);
        this.out.newline();
        if (el.getDataset() != null) {
            this.out.print("dataset");
        }
        el.getPatternElement().visit(this);
        this.out.decIndent(INDENT);
    }

    public void visit(ElementFilter el) {
        this.out.print("Constraint");
        this.out.incIndent(INDENT);
        this.out.newline();
        FmtExprPrefix.format(this.out, this.context, el.getExpr());
        this.out.decIndent(INDENT);
    }

    public void visit(ElementUnion el) {
        this.multiElement("Union", el.getElements().iterator());
    }

    public void visit(ElementGroup el) {
        this.multiElement("Group", el.getElements().iterator());
    }

    public void visit(ElementOptional el) {
        this.singleElement("Optional", el.getOptionalElement());
    }

    public void visit(ElementNamedGraph el) {
        this.singleElement("Graph", el.getElement());
    }

    public void visit(ElementUnsaid el) {
        this.singleElement("Unsaid", el.getElement());
    }

    private void singleElement(String name, Element element) {
        this.out.print(name);
        this.out.incIndent(INDENT);
        this.out.newline();
        element.visit(this);
        this.out.decIndent(INDENT);
    }

    private void multiElement(String name, Iterator iter) {
        this.out.print(name);
        this.out.incIndent(INDENT);
        while (iter.hasNext()) {
            this.out.newline();
            Element element = (Element)iter.next();
            element.visit(this);
        }
        this.out.decIndent(INDENT);
    }

    public void visit(TemplateTriple template) {
        Triple t = template.getTriple();
        this.formatTriple(t);
    }

    public void visit(TemplateGroup tGroup) {
        this.out.print("Template Group");
        this.out.incIndent(INDENT);
        Iterator iter = tGroup.templates();
        while (iter.hasNext()) {
            this.out.newline();
            Template sub = (Template)iter.next();
            sub.visit(this);
        }
        this.out.decIndent(INDENT);
        this.out.println();
    }
}

