/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryVisitor;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.serializer.FmtExprXML;
import com.hp.hpl.jena.sparql.serializer.FormatterElement;
import com.hp.hpl.jena.sparql.serializer.FormatterTemplate;
import com.hp.hpl.jena.sparql.serializer.FormatterXML;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;

public class QuerySerializerXML
implements QueryVisitor {
    static final int INDENT = 2;
    FormatterTemplate fmtTemplate;
    FormatterElement fmtElement;
    ExprVisitor fmtExpr;
    IndentedWriter out = null;

    QuerySerializerXML(OutputStream outStream, SerializationContext context) {
        this(new IndentedWriter(outStream), context);
    }

    QuerySerializerXML(IndentedWriter writer, SerializationContext context) {
        this.out = writer;
        FormatterXML fmt = new FormatterXML(writer, context);
        this.fmtElement = fmt;
        this.fmtTemplate = fmt;
        this.fmtExpr = new FmtExprXML(writer, context);
    }

    public void startVisit(Query query) {
        this.out.println("<rdf-query>");
        this.out.incIndent(2);
    }

    public void visitResultForm(Query query) {
    }

    public void visitPrologue(Prologue prologue) {
    }

    public void visitSelectResultForm(Query query) {
        this.out.print("<select");
        this.resultFormModifiers(query);
        this.out.println(">");
        this.out.incIndent(2);
        this.writeVarList(query.getResultVars());
        this.out.decIndent(2);
        this.out.println("</select>");
    }

    public void visitConstructResultForm(Query query) {
        this.out.print("<construct");
        this.resultFormModifiers(query);
        this.out.println(">");
        this.out.incIndent(2);
        query.getConstructTemplate().visit(this.fmtTemplate);
        this.out.decIndent(2);
        this.out.println("</construct>");
    }

    public void visitDescribeResultForm(Query query) {
        this.out.print("<describe");
        this.resultFormModifiers(query);
        this.out.println(">");
        this.out.incIndent(2);
        this.writeVarList(query.getResultVars());
        this.writeURIList(query.getResultURIs());
        this.out.decIndent(2);
        this.out.println("</describe>");
    }

    public void visitAskResultForm(Query query) {
        this.out.println("<ask/>");
    }

    public void visitDatasetDecl(Query query) {
    }

    public void visitQueryPattern(Query query) {
        if (query.getQueryPattern() != null) {
            query.getQueryPattern().visit(this.fmtElement);
        }
    }

    public void visitOrderBy(Query query) {
        if (query.hasOrderBy()) {
            this.out.println("<order>");
            this.out.incIndent(2);
            Iterator iter = query.getOrderBy().iterator();
            while (iter.hasNext()) {
                this.out.println("<order-by>");
                this.out.incIndent(2);
                SortCondition sc = (SortCondition)iter.next();
                sc.format(this.fmtExpr, this.out);
                this.out.decIndent(2);
                this.out.println("</order-by>");
            }
            this.out.decIndent(2);
            this.out.println("</order>");
        }
    }

    public void visitLimit(Query query) {
    }

    public void visitOffset(Query query) {
    }

    public void finishVisit(Query query) {
        this.out.decIndent(2);
        this.out.println("</rdf-query>");
        this.out.flush();
    }

    void writeVarList(List vars) {
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            String var = (String)iter.next();
            this.out.println("<variable name=\"" + var + "\"/>");
        }
    }

    void writeURIList(List uris) {
        Iterator iter = uris.iterator();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            this.out.println("<uri uri=\"" + uri + "\"/>");
        }
    }

    void resultFormModifiers(Query query) {
        if (query.isDistinct()) {
            this.out.print(" distinct=\"true\"");
        }
        if (query.hasLimit()) {
            this.out.print(" limit=\"" + query.getLimit() + "\"");
        }
        if (query.hasOffset()) {
            this.out.print(" offset=\"" + query.getOffset() + "\"");
        }
    }
}

