/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.serializer.FmtExpr;
import com.hp.hpl.jena.sparql.serializer.FmtExprARQ;
import com.hp.hpl.jena.sparql.serializer.FmtTemplateARQ;
import com.hp.hpl.jena.sparql.serializer.FormatterARQ;
import com.hp.hpl.jena.sparql.serializer.FormatterElement;
import com.hp.hpl.jena.sparql.serializer.FormatterTemplate;
import com.hp.hpl.jena.sparql.serializer.QuerySerializer;
import com.hp.hpl.jena.sparql.serializer.QuerySerializerPlain;
import com.hp.hpl.jena.sparql.serializer.QuerySerializerPrefix;
import com.hp.hpl.jena.sparql.serializer.QuerySerializerXML;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedLineBuffer;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.NodeToLabelMap;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Serializer {
    static final int BLOCK_INDENT = 2;
    private static Log log = LogFactory.getLog((Class)Serializer.class);

    public static void serialize(Query query, OutputStream out) {
        Serializer.serialize(query, out, null);
    }

    public static void serialize(Query query, OutputStream out, Syntax syntax) {
        IndentedWriter writer = new IndentedWriter(out);
        Serializer.serialize(query, writer, syntax);
        writer.flush();
        try {
            out.flush();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void serialize(Query query, IndentedLineBuffer buff) {
        Syntax s = query.getSyntax();
        if (s == null) {
            s = Syntax.syntaxSPARQL;
        }
        Serializer.serialize(query, buff, s);
    }

    public static void serialize(Query query, IndentedLineBuffer buff, Syntax outSyntax) {
        Serializer.serialize(query, buff.getIndentedWriter(), outSyntax);
    }

    public static void serialize(Query query, IndentedWriter writer) {
        Syntax s = query.getSyntax();
        if (s == null) {
            s = Syntax.syntaxSPARQL;
        }
        Serializer.serialize(query, writer, s);
    }

    public static void serialize(Query query, IndentedWriter writer, Syntax outSyntax) {
        if (outSyntax == null) {
            outSyntax = Syntax.syntaxSPARQL;
        }
        if (outSyntax.equals(Syntax.syntaxARQ)) {
            Serializer.serializeARQ(query, writer);
            writer.flush();
            return;
        }
        if (outSyntax.equals(Syntax.syntaxRDQL)) {
            Serializer.serializeRDQL(query, writer);
            writer.flush();
            return;
        }
        if (outSyntax.equals(Syntax.syntaxSPARQL)) {
            Serializer.serializeSPARQL(query, writer);
            writer.flush();
            return;
        }
        if (outSyntax.equals(Syntax.syntaxSPARQL_X)) {
            Serializer.serializeSPARQL_X(query, writer);
            writer.flush();
            return;
        }
        if (outSyntax.equals(Syntax.syntaxSPARQL)) {
            Serializer.serializeSPARQL(query, writer);
            writer.flush();
            return;
        }
        if (outSyntax.equals(Syntax.syntaxN3QL)) {
            Serializer.serializeN3QL(query, writer);
            writer.flush();
            return;
        }
        if (outSyntax.equals(Syntax.syntaxPrefix)) {
            Serializer.serializePrefix(query, writer);
            return;
        }
        if (outSyntax.equals(Syntax.syntaxDebug)) {
            Serializer.serializePlain(query, writer);
            return;
        }
        log.warn((Object)("Unknown syntax: " + outSyntax));
    }

    public static void serializeARQ(Query query, IndentedWriter writer) {
        SerializationContext cxt1 = new SerializationContext(query, new NodeToLabelMap("b", false));
        SerializationContext cxt2 = new SerializationContext(query, new NodeToLabelMap("c", false));
        Serializer.serializeARQ(query, writer, new FormatterARQ(writer, cxt1), new FmtExprARQ(writer, cxt1), new FmtTemplateARQ(writer, cxt2));
    }

    private static void serializeARQ(Query query, IndentedWriter writer, FormatterElement eltFmt, FmtExpr exprFmt, FormatterTemplate templateFmt) {
        QuerySerializer serilizer = new QuerySerializer(writer, eltFmt, exprFmt, templateFmt);
        query.visit(serilizer);
    }

    public static void serializeSPARQL(Query query, IndentedWriter writer) {
        Serializer.serializeARQ(query, writer);
    }

    public static void serializeSPARQL_X(Query query, IndentedWriter writer) {
        SerializationContext cxt = new SerializationContext(query, null);
        QuerySerializerXML serilizer = new QuerySerializerXML(writer, cxt);
        query.visit(serilizer);
    }

    public static void serializeRDQL(Query query, IndentedWriter writer) {
        log.warn((Object)"# unparseRDQL: Not implemented - Native syntax instead");
        Serializer.serializeARQ(query, writer);
    }

    public static void serializePrefix(Query query, IndentedWriter writer) {
        SerializationContext cxt = new SerializationContext(query, null);
        QuerySerializerPrefix serializer = new QuerySerializerPrefix(writer, cxt);
        query.visit(serializer);
    }

    public static void serializePlain(Query query, IndentedWriter writer) {
        SerializationContext cxt = new SerializationContext(query, null);
        QuerySerializerPlain serializer = new QuerySerializerPlain(writer, cxt);
        query.visit(serializer);
    }

    public static void serializeN3QL(Query query, IndentedWriter writer) {
        throw new UnsupportedOperationException("Not implemented: Formatting a query in N3QL syntax");
    }
}

