/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.syntax;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.LabelMap;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementVisitor;
import com.hp.hpl.jena.sparql.syntax.TripleCollector;
import java.util.Iterator;

public class ElementTriplesBlock
extends Element
implements TripleCollector {
    private BasicPattern pattern = new BasicPattern();

    public boolean isEmpty() {
        return this.pattern.isEmpty();
    }

    public void addTriple(Triple t) {
        this.pattern.add(t);
    }

    public int mark() {
        return this.pattern.size();
    }

    public void addTriple(int index, Triple t) {
        this.pattern.add(index, t);
    }

    public BasicPattern getTriples() {
        return this.pattern;
    }

    public Iterator triples() {
        return this.pattern.iterator();
    }

    public int hashCode() {
        int calcHashCode = 161;
        return calcHashCode ^= this.pattern.hashCode();
    }

    public boolean equalTo(Element el2, LabelMap labelMap) {
        if (el2 == null) {
            return false;
        }
        if (!(el2 instanceof ElementTriplesBlock)) {
            return false;
        }
        ElementTriplesBlock eg2 = (ElementTriplesBlock)el2;
        if (this.pattern.size() != eg2.pattern.size()) {
            return false;
        }
        for (int i = 0; i < this.pattern.size(); ++i) {
            Triple t2;
            Triple t1 = this.pattern.get(i);
            if (ElementTriplesBlock.equalTo(t1, t2 = eg2.pattern.get(i), labelMap)) continue;
            return false;
        }
        return true;
    }

    public void visit(ElementVisitor v) {
        v.visit(this);
    }

    private static boolean equalTo(Triple t1, Triple t2, LabelMap labelMap) {
        Node s1 = t1.getSubject();
        Node p1 = t1.getPredicate();
        Node o1 = t1.getObject();
        Node s2 = t2.getSubject();
        Node p2 = t2.getPredicate();
        Node o2 = t2.getObject();
        if (!ElementTriplesBlock.nodeEquals(s1, s2, labelMap)) {
            return false;
        }
        if (!ElementTriplesBlock.nodeEquals(p1, p2, labelMap)) {
            return false;
        }
        return ElementTriplesBlock.nodeEquals(o1, o2, labelMap);
    }

    private static boolean nodeEquals(Node n1, Node n2, LabelMap labelMap) {
        if (Var.isBlankNodeVar(n1) && Var.isBlankNodeVar(n2)) {
            String label1 = n1.getName();
            String label2 = n2.getName();
            String maybe = labelMap.get(label1);
            if (maybe == null) {
                labelMap.put(label1, label2);
                return true;
            }
            return maybe.equals(label2);
        }
        return n1.equals((Object)n2);
    }
}

