/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.syntax;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.LabelMap;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.syntax.TemplateVisitor;
import java.util.Collection;
import java.util.Map;

public class TemplateTriple
extends Template {
    Triple triple;

    public TemplateTriple(Node s, Node p, Node o) {
        this.triple = new Triple(s, p, o);
    }

    public TemplateTriple(Triple t) {
        this.triple = t;
    }

    public Triple getTriple() {
        return this.triple;
    }

    public void subst(Collection acc, Map bNodeMap, Binding b) {
        Node s = this.triple.getSubject();
        Node p = this.triple.getPredicate();
        Node o = this.triple.getObject();
        if (s.isBlank()) {
            s = this.newBlank(s, bNodeMap);
        }
        if (p.isBlank()) {
            p = this.newBlank(p, bNodeMap);
        }
        if (o.isBlank()) {
            o = this.newBlank(o, bNodeMap);
        }
        Triple t = new Triple(s, p, o);
        Triple t2 = BindingUtils.substituteIntoTriple(t, b);
        acc.add(t2);
    }

    public int hashCode() {
        this.triple.hashCode();
        if (this.triple == null) {
            return 2;
        }
        int hash = 0;
        hash = this.hashNode(this.triple.getSubject()) ^ hash << 1;
        hash = this.hashNode(this.triple.getPredicate()) ^ hash << 1;
        hash = this.hashNode(this.triple.getObject()) ^ hash << 1;
        return hash;
    }

    private int hashNode(Node node) {
        if (node.isBlank()) {
            return 57;
        }
        return node.hashCode();
    }

    public boolean equalTo(Object temp2, LabelMap labelMap) {
        if (temp2 == null) {
            return false;
        }
        if (!(temp2 instanceof TemplateTriple)) {
            return false;
        }
        TemplateTriple tt2 = (TemplateTriple)temp2;
        if (labelMap == null) {
            return this.getTriple().equals((Object)tt2.getTriple());
        }
        Node s1 = this.getTriple().getSubject();
        Node p1 = this.getTriple().getPredicate();
        Node o1 = this.getTriple().getObject();
        Node s2 = tt2.getTriple().getSubject();
        Node p2 = tt2.getTriple().getPredicate();
        Node o2 = tt2.getTriple().getObject();
        if (!TemplateTriple.nodeEquals(s1, s2, labelMap)) {
            return false;
        }
        if (!TemplateTriple.nodeEquals(p1, p2, labelMap)) {
            return false;
        }
        return TemplateTriple.nodeEquals(o1, o2, labelMap);
    }

    public void visit(TemplateVisitor visitor) {
        visitor.visit(this);
    }

    private static boolean nodeEquals(Node n1, Node n2, LabelMap labelMap) {
        if (n1.isBlank() && n2.isBlank()) {
            String label1 = n1.getBlankNodeLabel();
            String label2 = n2.getBlankNodeLabel();
            String maybe = labelMap.get(label1);
            if (maybe == null) {
                labelMap.put(label1, label2);
                return true;
            }
            return maybe.equals(label2);
        }
        return n1.equals((Object)n2);
    }

    private Node newBlank(Node n, Map bNodeMap) {
        if (!bNodeMap.containsKey(n)) {
            bNodeMap.put(n, Node.createAnon());
        }
        return (Node)bNodeMap.get(n);
    }
}

