/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.NodeVar;
import com.hp.hpl.jena.sparql.lang.sparql.ParseException;
import com.hp.hpl.jena.sparql.lang.sparql.SPARQLParser;
import com.hp.hpl.jena.sparql.lang.sparql.Token;
import com.hp.hpl.jena.sparql.lang.sparql.TokenMgrError;
import com.hp.hpl.jena.sparql.serializer.FmtExprARQ;
import com.hp.hpl.jena.sparql.serializer.FmtExprPrefix;
import com.hp.hpl.jena.sparql.util.IndentedLineBuffer;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.PrintUtils;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ExprUtils {
    private static PrintUtils.Fmt fmtARQ = new PrintUtils.Fmt(){

        public String fmt(Object thing) {
            return null;
        }
    };

    public static Expr nodeToExpr(Node n) {
        if (n.isVariable()) {
            return new NodeVar(n);
        }
        return NodeValue.makeNode(n);
    }

    public static String joinList(List args, String sep) {
        if (args == null) {
            return "<<Null list>>";
        }
        if (args.size() == 0) {
            return "<<Empty list>>";
        }
        StringBuffer s = new StringBuffer();
        boolean first = true;
        ListIterator iter = args.listIterator();
        while (iter.hasNext()) {
            Expr ex;
            if (!first) {
                s.append(sep);
            }
            if ((ex = (Expr)iter.next()) instanceof NodeValue) {
                NodeValue nv = (NodeValue)ex;
                s.append(nv.asQuotedString());
            } else {
                s.append(ex.toString());
            }
            first = false;
        }
        return s.toString();
    }

    public static Expr parse(String s) {
        return ExprUtils.parse(s, ARQConstants.getGlobalPrefixMap());
    }

    public static Expr parse(String s, PrefixMapping pmap) {
        Query query = QueryFactory.make();
        query.setPrefixMapping(pmap);
        return ExprUtils.parse(query, s, true);
    }

    public static Expr parse(Query query, String s, boolean checkAllUsed) {
        try {
            StringReader in = new StringReader(s);
            SPARQLParser parser = new SPARQLParser(in);
            parser.setQuery(query);
            Expr expr = parser.Expression();
            if (checkAllUsed) {
                Token t = parser.getNextToken();
                if (t.kind != 0) {
                    throw new QueryParseException("Extra tokens beginning \"" + t.image + "\" starting line " + t.beginLine + ", column " + t.beginColumn, t.beginLine, t.beginColumn);
                }
            }
            return expr;
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginLine);
        }
        catch (TokenMgrError tErr) {
            throw new QueryParseException(tErr.getMessage(), -1, -1);
        }
        catch (Error err) {
            String tmp = err.getMessage();
            if (tmp == null) {
                throw new QueryParseException(err, -1, -1);
            }
            throw new QueryParseException(tmp, -1, -1);
        }
    }

    public static NodeValue parseNodeValue(String s) {
        try {
            Query query = QueryFactory.make();
            query.setPrefixMapping(ARQConstants.getGlobalPrefixMap());
            StringReader in = new StringReader(s);
            SPARQLParser parser = new SPARQLParser(in);
            parser.setQuery(query);
            Node n = parser.GraphTerm();
            Token t = parser.getNextToken();
            if (t.kind != 0) {
                throw ExprUtils.makeException("Extra tokens beginning \"" + t.image + "\" starting line " + t.beginLine + ", column " + t.beginColumn, t.beginLine, t.beginColumn);
            }
            NodeValue nv = NodeValue.makeNode(n);
            return nv;
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
    }

    private static QueryParseException makeException(String msg, int line, int column) {
        return new QueryParseException(msg, line, column);
    }

    public static void fmtSPARQL(IndentedWriter iOut, Expr expr, PrefixMapping pmap) {
        FmtExprARQ v = new FmtExprARQ(iOut, pmap);
        expr.visit(v);
    }

    public static void fmtSPARQL(IndentedWriter iOut, Expr expr) {
        ExprUtils.fmtSPARQL(iOut, expr, ARQConstants.getGlobalPrefixMap());
    }

    public static String fmtSPARQL(Expr expr) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        ExprUtils.fmtSPARQL(buff.getIndentedWriter(), expr);
        return buff.toString();
    }

    public static void fmtPrefix(IndentedWriter iOut, Expr expr, PrefixMapping pmap) {
        FmtExprPrefix v = new FmtExprPrefix(iOut, pmap);
        expr.visit(v);
    }

    public static void fmtPrefix(IndentedWriter iOut, Expr expr) {
        ExprUtils.fmtPrefix(iOut, expr, ARQConstants.getGlobalPrefixMap());
    }

    public static String fmtPrefix(Expr expr) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        ExprUtils.fmtPrefix(buff.getIndentedWriter(), expr);
        return buff.toString();
    }

    public static void fmtSPARQL(IndentedWriter iOut, ExprList exprs, PrefixMapping pmap) {
        FmtExprARQ v = new FmtExprARQ(iOut, pmap);
        String sep = "";
        Iterator iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = (Expr)iter.next();
            iOut.print(sep);
            sep = " , ";
            expr.visit(v);
        }
    }

    public static void fmtSPARQL(IndentedWriter iOut, ExprList exprs) {
        ExprUtils.fmtSPARQL(iOut, exprs, ARQConstants.getGlobalPrefixMap());
    }

    public static String fmtSPARQL(ExprList exprs) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        ExprUtils.fmtSPARQL(buff.getIndentedWriter(), exprs);
        return buff.toString();
    }

    public static void fmtPrefix(IndentedWriter iOut, ExprList exprs, PrefixMapping pmap) {
        ExprUtils.fmtPrefix(iOut, exprs, 0, pmap);
    }

    private static void fmtPrefix(IndentedWriter iOut, ExprList exprs, int i, PrefixMapping pmap) {
        FmtExprPrefix v = new FmtExprPrefix(iOut, pmap);
        if (exprs.size() <= i) {
            throw new ARQInternalErrorException("ExprList too short (Size:" + exprs.size() + "<=" + i + ")");
        }
        if (exprs.size() == i + 1) {
            exprs.get(i).visit(v);
            return;
        }
        iOut.print("( && ");
        exprs.get(i).visit(v);
        iOut.print(" ");
        ExprUtils.fmtPrefix(iOut, exprs, i + 1, pmap);
        iOut.print(")");
    }

    public static void fmtPrefix(IndentedWriter iOut, ExprList exprs) {
        ExprUtils.fmtPrefix(iOut, exprs, ARQConstants.getGlobalPrefixMap());
    }

    public static String fmtPrefix(ExprList exprs) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        ExprUtils.fmtPrefix(buff.getIndentedWriter(), exprs);
        return buff.toString();
    }

    public static String strComparison(int cmp) {
        switch (cmp) {
            case 1: {
                return "GT";
            }
            case 0: {
                return "EQ";
            }
            case -1: {
                return "LT";
            }
        }
        return "??";
    }
}

