/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedLineBuffer;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.PrintSerializable;
import com.hp.hpl.jena.sparql.util.Printable;
import com.hp.hpl.jena.sparql.util.Utils;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PrintUtils {
    private static Fmt itemFmt = new Fmt(){

        public String fmt(Object thing) {
            if (thing == null) {
                return "<null>";
            }
            return thing.toString();
        }
    };

    public static String toString(Printable f) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        IndentedWriter out = buff.getIndentedWriter();
        f.output(out);
        return buff.toString();
    }

    public static String toString(PrintSerializable item, PrefixMapping pmap) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        IndentedWriter out = buff.getIndentedWriter();
        SerializationContext sCxt = new SerializationContext(pmap);
        item.output(out, sCxt);
        return buff.toString();
    }

    public static String toString(PrintSerializable item) {
        return PrintUtils.toString(item, ARQConstants.getGlobalPrefixMap());
    }

    public static void output(PrintSerializable item, IndentedWriter out) {
        out.print("(");
        out.print(Utils.className(item));
        out.print(")");
    }

    public static void printList(IndentedWriter out, Collection list, String sep, Fmt itemFmt) {
        String sep$ = "";
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            out.print(sep$);
            sep$ = sep;
            Object obj = iter.next();
            out.print(itemFmt.fmt(obj));
        }
    }

    public static void printList(IndentedWriter out, Collection list, String sep) {
        PrintUtils.printList(out, list, sep, itemFmt);
    }

    public static void printList(IndentedWriter out, Collection list) {
        PrintUtils.printList(out, list, " ");
    }

    public static void printList(PrintStream out, Collection list, String sep, Fmt itemFmt) {
        String sep$ = "";
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            out.print(sep$);
            sep$ = sep;
            Object obj = iter.next();
            out.print(itemFmt.fmt(obj));
        }
    }

    public static void printList(PrintStream out, List list, String sep) {
        PrintUtils.printList(out, (Collection)list, sep, itemFmt);
    }

    public static void printList(PrintStream out, List list) {
        PrintUtils.printList(out, list, " ");
    }

    public static interface Fmt {
        public String fmt(Object var1);
    }
}

