/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.resultset.PlainFormat;
import com.hp.hpl.jena.sparql.resultset.ResultSetApply;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import com.hp.hpl.jena.sparql.vocabulary.ResultSetGraphVocab;
import java.io.OutputStream;
import java.util.List;

public class QueryExecUtils {
    protected static PrefixMapping globalPrefixMap = new PrefixMappingImpl();

    public static void executeQuery(Query query, QueryExecution queryExecution) {
        QueryExecUtils.executeQuery(query, queryExecution, ResultsFormat.FMT_TEXT);
    }

    public static void executeQuery(Query query, QueryExecution queryExecution, ResultsFormat outputFormat) {
        if (query.isSelectType()) {
            QueryExecUtils.doSelectQuery(query, queryExecution, outputFormat);
        }
        if (query.isDescribeType()) {
            QueryExecUtils.doDescribeQuery(query, queryExecution, outputFormat);
        }
        if (query.isConstructType()) {
            QueryExecUtils.doConstructQuery(query, queryExecution, outputFormat);
        }
        if (query.isAskType()) {
            QueryExecUtils.doAskQuery(query, queryExecution, outputFormat);
        }
        queryExecution.close();
    }

    public static void executeAlgebra(Op op, DatasetGraph dsg, ResultsFormat outputFormat) {
        QueryEngineFactory f = QueryEngineRegistry.findFactory(op, dsg, null);
        Plan plan = f.create(op, dsg, BindingRoot.create(), null);
        QueryIterator qIter = plan.iterator();
        List vars = null;
        vars = op instanceof OpProject ? Var.varNames(((OpProject)op).getVars()) : Var.varNames(OpVars.allVars(op));
        ResultSet results = ResultSetFactory.create(qIter, vars);
        QueryExecUtils.outputResultSet(results, null, outputFormat);
    }

    public static void outputResultSet(ResultSet results, PrefixMapping prefixMapping, ResultsFormat outputFormat) {
        boolean done = false;
        if (prefixMapping == null) {
            prefixMapping = globalPrefixMap;
        }
        if (outputFormat.equals(ResultsFormat.FMT_UNKNOWN)) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        if (outputFormat.equals(ResultsFormat.FMT_NONE) || outputFormat.equals(ResultsFormat.FMT_COUNT)) {
            int count = ResultSetFormatter.consume(results);
            if (outputFormat.equals(ResultsFormat.FMT_COUNT)) {
                System.out.println("Count = " + count);
            }
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_RDF) || outputFormat.equals(ResultsFormat.FMT_RDF_N3) || outputFormat.equals(ResultsFormat.FMT_RDF_TTL)) {
            Model m = ResultSetFormatter.toModel(results);
            m.setNsPrefixes(prefixMapping);
            RDFWriter rdfw = m.getWriter("TURTLE");
            m.setNsPrefix("rs", ResultSetGraphVocab.getURI());
            rdfw.write(m, (OutputStream)System.out, null);
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML((OutputStream)System.out, results);
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_JSON)) {
            ResultSetFormatter.outputAsJSON((OutputStream)System.out, results);
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_TEXT)) {
            ResultSetFormatter.out((OutputStream)System.out, results, prefixMapping);
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_TUPLES)) {
            PlainFormat pFmt = new PlainFormat((OutputStream)System.out, prefixMapping);
            ResultSetApply a = new ResultSetApply(results, pFmt);
            a.apply();
            done = true;
        }
        if (!done) {
            System.err.println("Unknown format request: " + outputFormat);
        }
        results = null;
        System.out.flush();
    }

    private static void doSelectQuery(Query query, QueryExecution qe, ResultsFormat outputFormat) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        ResultSet results = qe.execSelect();
        QueryExecUtils.outputResultSet(results, query.getPrefixMapping(), outputFormat);
    }

    private static void doDescribeQuery(Query query, QueryExecution qe, ResultsFormat outputFormat) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_RDF_TTL;
        }
        Model r = qe.execDescribe();
        QueryExecUtils.writeModel(query, r, outputFormat);
    }

    private static void doConstructQuery(Query query, QueryExecution qe, ResultsFormat outputFormat) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_RDF_TTL;
        }
        Model r = qe.execConstruct();
        QueryExecUtils.writeModel(query, r, outputFormat);
    }

    private static void writeModel(Query query, Model model, ResultsFormat outputFormat) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        if (outputFormat.equals(ResultsFormat.FMT_NONE)) {
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_TEXT)) {
            String qType = "";
            if (query.isDescribeType()) {
                qType = "DESCRIBE";
            }
            if (query.isConstructType()) {
                qType = "CONSTRUCT";
            }
            System.out.println("# ======== " + qType + " results ");
            model.write((OutputStream)System.out, "N3", null);
            System.out.println("# ======== ");
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_XML)) {
            model.write((OutputStream)System.out, "RDF/XML-ABBREV", null);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_TTL)) {
            model.write((OutputStream)System.out, "N3", null);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_N3)) {
            model.write((OutputStream)System.out, "N3", null);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_NT)) {
            model.write((OutputStream)System.out, "N_TRIPLES", null);
            return;
        }
        System.err.println("Unknown format: " + outputFormat.getSymbol());
    }

    private static void doAskQuery(Query query, QueryExecution qe, ResultsFormat outputFormat) {
        boolean b = qe.execAsk();
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML((OutputStream)System.out, b);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_N3) || outputFormat.equals(ResultsFormat.FMT_RDF_TTL)) {
            ResultSetFormatter.outputAsRDF((OutputStream)System.out, "TURTLE", b);
            System.out.flush();
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_JSON)) {
            ResultSetFormatter.outputAsJSON((OutputStream)System.out, b);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_TEXT)) {
            System.out.println("Ask => " + (b ? "Yes" : "No"));
            return;
        }
        System.err.println("Unknown format: " + outputFormat.getSymbol());
    }

    static {
        globalPrefixMap.setNsPrefix("rdf", ARQConstants.rdfPrefix);
        globalPrefixMap.setNsPrefix("rdfs", ARQConstants.rdfsPrefix);
        globalPrefixMap.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        globalPrefixMap.setNsPrefix("rs", ResultSetGraphVocab.getURI());
    }
}

