/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.db.factory;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.geneontology.db.model.Association;
import org.geneontology.db.model.DB;
import org.geneontology.db.model.DBXref;
import org.geneontology.db.model.GeneProduct;
import org.geneontology.db.model.GraphPath;
import org.geneontology.db.model.Species;
import org.geneontology.db.model.Term;
import org.geneontology.db.model.TermSynonym;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;

public class GOobjectFactory {
    private static SessionFactory sessionsFactory;
    private static String message;

    public GOobjectFactory(String config) {
        block2: {
            try {
                sessionsFactory = GOobjectFactory.buildSessionFactory(config);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!(e instanceof SQLException)) break block2;
                GOobjectFactory.printSQLException((SQLException)e);
            }
        }
    }

    private static SessionFactory buildSessionFactory(String config) {
        try {
            Configuration configuration = new Configuration();
            configuration.configure(new File(config));
            ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).buildServiceRegistry();
            return configuration.buildSessionFactory(serviceRegistry);
        }
        catch (Throwable ex) {
            System.err.println("Initial SessionFactory creation failed." + ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    public void close() {
        sessionsFactory.close();
    }

    public synchronized Session startSession() {
        Session session = null;
        try {
            session = sessionsFactory.getCurrentSession();
            session.beginTransaction();
            message = "";
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            message = e.getMessage();
            session = null;
        }
        return session;
    }

    public synchronized String getMessage() {
        return message;
    }

    public synchronized Term getTermByAcc(String acc, Session session) {
        if (acc == null || session == null) {
            return null;
        }
        Term term = (Term)session.createQuery("from Term where acc = ?").setString(0, acc).uniqueResult();
        return term;
    }

    public synchronized Term getTermByAlternateAcc(String acc, Session session) {
        String query = "from TermSynonym where acc_synonym = ?";
        Query q = session.createQuery(query);
        q.setString(0, acc);
        TermSynonym ts = (TermSynonym)q.uniqueResult();
        if (ts == null) {
            return null;
        }
        return ts.getTerm();
    }

    public synchronized Term getTermByName(String name, Session session) {
        Iterator results = session.createQuery("from Term where name = ?").setString(0, name).iterate();
        Term term = null;
        int cnt = 0;
        while (results.hasNext()) {
            term = (Term)results.next();
            ++cnt;
        }
        if (cnt > 1) {
            System.out.println("Retrieved " + cnt + " terms with name " + name);
        }
        return term;
    }

    public synchronized DBXref getDBXrefByID(int id, Session session) {
        return (DBXref)session.createQuery("from DBXref where id = ?").setInteger(0, id).uniqueResult();
    }

    public synchronized DBXref getDBXrefByDBAcc(String db, String acc, Session session) {
        Query q = session.createQuery("from DBXref where db = ? and acc = ?");
        q.setString(0, db);
        q.setString(1, acc);
        return (DBXref)q.uniqueResult();
    }

    public synchronized DB getDBByName(String name, Session session) {
        return (DB)session.createQuery("from DB where name = ?").setString(0, name).uniqueResult();
    }

    public synchronized Iterator<GeneProduct> getGPListByDBXref(List<String[]> xrefs, Session session) {
        String query_str = "select g from GeneProduct as g inner join g.dbxref as xref where ";
        String prefix = "";
        Iterator<String[]> xref_it = xrefs.iterator();
        while (xref_it.hasNext()) {
            xref_it.next();
            query_str = query_str + prefix + "(xref.db_name = ? and xref.accession = ?)";
            prefix = " or ";
        }
        Query query = session.createQuery(query_str);
        int param_count = 0;
        for (String[] xref : xrefs) {
            query.setString(param_count++, xref[0]);
            query.setString(param_count++, xref[1]);
        }
        Iterator results = query.iterate();
        return results;
    }

    public synchronized Iterator<GeneProduct> getGPListBySeqXref(List<String[]> xrefs, Session session) {
        ArrayList<GeneProduct> genes = new ArrayList<GeneProduct>();
        for (String[] xref : xrefs) {
            String query_str = "select gp from GeneProduct as gp inner join gp.seqs as link inner join link.seq as seq inner join seq.dbxrefs as xref where (xref.db_name = ? and xref.accession = ?)";
            Query query = session.createQuery(query_str);
            if (xref[0].equals("UniProtKB")) {
                query.setString(0, "Uniprot");
            } else {
                query.setString(0, xref[0]);
            }
            query.setString(1, xref[1]);
            GeneProduct results = (GeneProduct)query.uniqueResult();
            if (results == null) continue;
            genes.add(results);
        }
        return genes.iterator();
    }

    public synchronized GeneProduct getGPByDBXref(String db_name, String db_key, Session session) {
        GeneProduct gp = (GeneProduct)session.createQuery("select g from GeneProduct as g inner join g.dbxref as xref  where xref.db_name = ? and xref.accession = ?").setString(0, db_name).setString(1, db_key).uniqueResult();
        return gp;
    }

    public synchronized GeneProduct getGPByDBXrefStr(String xrefStr, Session session) {
        String[] parts = xrefStr.split(":", 2);
        return this.getGPByDBXref(parts[0], parts[1], session);
    }

    public synchronized GeneProduct getGPByAcc(String seq_acc, Session session) {
        GeneProduct gp = (GeneProduct)session.createQuery("select g from GeneProduct as g inner join g.dbxref as xref  where xref.accession = ?").setString(0, seq_acc).uniqueResult();
        return gp;
    }

    public synchronized GeneProduct getGPByDBXref_ID(int dbxref_id, Session session) {
        return (GeneProduct)session.createQuery("from GeneProduct where dbxref_id = ?").setInteger(0, dbxref_id).uniqueResult();
    }

    public synchronized GeneProduct getGPByID(int gene_id, Session session) {
        return (GeneProduct)session.createQuery("from GeneProduct where id = ?").setInteger(0, gene_id).uniqueResult();
    }

    public synchronized Iterator<GeneProduct> getGPByName(String name, Session session) {
        return session.createQuery("from GeneProduct where symbol = ?").setString(0, name).iterate();
    }

    public synchronized Iterator<GeneProduct> getGPBySeq(String db_key, Session session) {
        return session.createQuery("select g from GeneProduct as g inner join g.seqs as seq_link inner join seq_link.seq as seq inner join seq.dbxrefs as xref where xref.accession = ?").setString(0, db_key).iterate();
    }

    public synchronized Species getSpeciesByTaxa(int taxa, Session session) {
        return (Species)session.createQuery("from Species where ncbi_taxa_id = ?").setInteger(0, taxa).uniqueResult();
    }

    public synchronized GraphPath getPath(int id1, int id2, Session session) {
        Query q = session.createQuery("from GraphPath p where p.object = ? and p.subject = ?");
        q.setInteger(0, id1);
        q.setInteger(1, id2);
        GraphPath path = null;
        List path_list = null;
        try {
            path_list = q.list();
        }
        catch (Exception e) {
            if (HibernateException.class.isInstance(e)) {
                System.out.println("HibernateException: " + e.getMessage());
            } else if (SQLException.class.isInstance(e)) {
                System.out.println("SQLException: " + e.getMessage());
            } else {
                System.out.println(e.getClass().toString() + " Exception: " + e.getMessage() + " on " + q.getQueryString());
            }
            session.cancelQuery();
        }
        if (path_list == null || path_list.size() == 0) {
            q = session.createQuery("from GraphPath p where p.object = ? and p.subject = ?");
            q.setInteger(0, id2);
            q.setInteger(1, id1);
            try {
                path_list = q.list();
            }
            catch (Exception e) {
                if (HibernateException.class.isInstance(e)) {
                    System.out.println("HibernateException: " + e.getMessage());
                } else if (SQLException.class.isInstance(e)) {
                    System.out.println("SQLException: " + e.getMessage());
                } else {
                    System.out.println(e.getClass().toString() + " Exception: " + e.getMessage() + " on " + q.getQueryString());
                }
                session.cancelQuery();
            }
        }
        if (path_list != null && path_list.size() > 0) {
            path = (GraphPath)path_list.get(0);
            if (path_list.size() > 1) {
                for (int i = 1; i < path_list.size(); ++i) {
                    GraphPath alt = (GraphPath)path_list.get(i);
                    if (alt.getDistance() <= path.getDistance()) continue;
                    path = alt;
                }
            }
        }
        return path;
    }

    public synchronized GraphPath getPath(Term term1, Term term2, Session session) {
        GraphPath path = null;
        if (term1 != null && term2 != null) {
            path = this.getPath(term1.getTerm_id(), term2.getTerm_id(), session);
        }
        return path;
    }

    public synchronized List<Species> getSpeciesByName(String genus, String species, Session session) {
        List<Species> specie_list = new ArrayList<Species>();
        try {
            if (species != null && !species.equals("")) {
                Query q = session.createQuery("from Species where genus = ? and species = ?");
                q.setString(0, genus);
                q.setString(1, species);
                Species result = (Species)q.uniqueResult();
                specie_list.add(result);
                return specie_list;
            }
            Query q = session.createQuery("from Species where genus = ?");
            q.setString(0, genus);
            q.toString();
            specie_list = q.list();
        }
        catch (Exception e) {
            if (HibernateException.class.isInstance(e)) {
                System.out.println("HibernateException: " + e.getMessage());
            } else if (SQLException.class.isInstance(e)) {
                System.out.println("SQLException: " + e.getMessage());
            } else {
                e.printStackTrace();
            }
            session.close();
        }
        return specie_list;
    }

    public synchronized Iterator<Association> getAssociationsIteratorByGP(GeneProduct gp, Session session) {
        Iterator it = session.createQuery("from Association where gene_product = ?").setEntity(0, (Object)gp).iterate();
        return it;
    }

    public synchronized Vector<Term> getTermIntersection(HashMap<Term, Vector<Association>> annots, Session session) {
        Vector<String> gp_ids = new Vector<String>(annots.size());
        for (Vector<Association> assocs : annots.values()) {
            for (Association annot : assocs) {
                DBXref gp_xref = annot.getGene_product().getDbxref();
                String gp_id = gp_xref.getDb_name() + ":" + gp_xref.getAccession();
                if (gp_ids.contains(gp_id)) continue;
                gp_ids.add(gp_id);
            }
        }
        return this.getTermIntersectionByGP(gp_ids, session);
    }

    public synchronized Vector<Term> getTermIntersectionByGP(Collection<String> gp_ids, Session session) {
        Query query = session.createQuery("select term.term_id, COUNT(DISTINCT gene_product.gp_id) FROM Association as association, GeneProduct as gene_product, DBXref as xref, GraphPath as graph_path, Term as term WHERE association.is_not = 0 AND gene_product.gp_id = association.gene_product AND xref.dbxref_id = gene_product.dbxref AND graph_path.subject = association.term AND term.term_id = graph_path.object AND term.is_obsolete = 0 AND xref.accession IN (:gp_list) GROUP BY term.term_id");
        query.setParameterList("gp_list", gp_ids);
        Iterator it = query.list().iterator();
        Vector<Term> terms = new Vector<Term>();
        while (it.hasNext()) {
            Object[] row = (Object[])it.next();
            Integer term_id = (Integer)row[0];
            Long gp_count = (Long)row[1];
            if (gp_count.intValue() != gp_ids.size()) continue;
            Term term = (Term)session.createQuery("from Term where id = ?").setLong(0, term_id.longValue()).uniqueResult();
            terms.add(term);
        }
        return terms;
    }

    public static void printSQLException(SQLException ex) {
        for (Throwable e : ex) {
            if (!(e instanceof SQLException)) continue;
            e.printStackTrace(System.err);
            System.err.println("SQLState: " + ((SQLException)e).getSQLState());
            System.err.println("Error Code: " + ((SQLException)e).getErrorCode());
            System.err.println("Message: " + e.getMessage());
            for (Throwable t = ex.getCause(); t != null; t = t.getCause()) {
                System.out.println("Cause: " + t);
            }
        }
    }

    public static void getWarningsFromResultSet(ResultSet rs) throws SQLException {
        GOobjectFactory.printWarnings(rs.getWarnings());
    }

    public static void getWarningsFromStatement(Statement stmt) throws SQLException {
        GOobjectFactory.printWarnings(stmt.getWarnings());
    }

    public static void printWarnings(SQLWarning warning) throws SQLException {
        if (warning != null) {
            System.out.println("\n---Warning---\n");
            while (warning != null) {
                System.out.println("Message: " + warning.getMessage());
                System.out.println("SQLState: " + warning.getSQLState());
                System.out.print("Vendor error code: ");
                System.out.println(warning.getErrorCode());
                System.out.println("");
                warning = warning.getNextWarning();
            }
        }
    }

    static {
        message = "";
    }
}

