/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.db.model;

import java.util.HashSet;
import java.util.Set;
import org.geneontology.db.model.Association;
import org.geneontology.db.model.DBXref;
import org.geneontology.db.model.GOModel;

public class Evidence
extends GOModel {
    public static final String[][] evidence_codes = new String[][]{{"EXP", "Experimental data"}, {"IC", "Curator"}, {"IDA", "Direct Assay"}, {"IEA", "Electronic Analysis"}, {"IEP", "Expression Pattern"}, {"IGC", "Genomic Context"}, {"IGI", "Genetic Interaction"}, {"IMP", "Mutant Phenotype"}, {"IPI", "Physical Interaction"}, {"ISA", "Sequence Alignment"}, {"ISM", "Sequence Model Similarity"}, {"ISO", "Sequence Orthology"}, {"ISS", "Sequence or Structural Similarity"}, {"NAS", "Not-traceable Author Statement"}, {"ND", "No data available"}, {"NR", "Not Recorded"}, {"RCA", "Reviewed Computational Analysis"}, {"TAS", "Traceable Author Statement"}};
    protected int evidence_id;
    protected String code;
    protected Association association;
    protected DBXref dbxref;
    protected Set<DBXref> withs;

    public Evidence() {
        String[] uniqueConstraintFields = new String[]{"code", "association", "dbxref"};
        this.initUniqueConstraintFields(Evidence.class, uniqueConstraintFields);
    }

    public int getEvidence_id() {
        return this.evidence_id;
    }

    public void setEvidence_id(int evidence_id) {
        this.evidence_id = evidence_id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Association getAssociation() {
        return this.association;
    }

    public void setAssociation(Association association) {
        this.association = association;
    }

    public DBXref getDbxref() {
        return this.dbxref;
    }

    public void setDbxref(DBXref dbxref) {
        this.dbxref = dbxref;
    }

    public Set<DBXref> getWiths() {
        if (this.withs == null) {
            this.withs = new HashSet<DBXref>();
        }
        return this.withs;
    }

    public void setWiths(Set<DBXref> withs) {
        this.withs = withs;
    }

    public void addWith(DBXref with) {
        if (this.withs == null) {
            this.withs = new HashSet<DBXref>();
        }
        this.withs.add(with);
    }

    public String getTip() {
        String tip = null;
        for (int i = 0; i < evidence_codes.length && tip == null; ++i) {
            if (!evidence_codes[i][0].equals(this.code)) continue;
            tip = evidence_codes[i][1];
        }
        return tip;
    }
}

