/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.db.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.geneontology.db.model.Association;
import org.geneontology.db.model.DBXref;
import org.geneontology.db.model.GOModel;
import org.geneontology.db.model.HomolSet;
import org.geneontology.db.model.ProductSeq;
import org.geneontology.db.model.Species;
import org.geneontology.db.model.Term;

public class GeneProduct
extends GOModel {
    protected int gp_id;
    protected String symbol;
    protected DBXref dbxref;
    protected Species species;
    protected Term SO_type;
    protected String full_name;
    protected Set<String> synonyms;
    protected Set<ProductSeq> seqs;
    protected HomolSet homol_set;
    protected Set<Association> associations;

    public GeneProduct() {
        String[] uniqueConstraintFields = new String[]{"dbxref"};
        this.initUniqueConstraintFields(GeneProduct.class, uniqueConstraintFields);
    }

    public int getGp_id() {
        return this.gp_id;
    }

    public void setGp_id(int gp_id) {
        this.gp_id = gp_id;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public DBXref getDbxref() {
        return this.dbxref;
    }

    public void setDbxref(DBXref dbxref) {
        this.dbxref = dbxref;
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        this.species = species;
    }

    public Term getSO_type() {
        return this.SO_type;
    }

    public void setSO_type(Term so_type) {
        this.SO_type = so_type;
    }

    public String getFull_name() {
        return this.full_name;
    }

    public void setFull_name(String full_name) {
        this.full_name = full_name;
    }

    public Set<String> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(Set<String> synonyms) {
        this.synonyms = synonyms;
    }

    public Set<ProductSeq> getSeqs() {
        return this.seqs;
    }

    public void setSeqs(Set<ProductSeq> seqs) {
        this.seqs = seqs;
    }

    public HomolSet getHomol_set() {
        return this.homol_set;
    }

    public void setHomol_set(HomolSet homol_set) {
        this.homol_set = homol_set;
    }

    public Set<Association> getAssociations() {
        if (this.associations == null) {
            this.associations = new HashSet<Association>();
        }
        return this.associations;
    }

    public synchronized void setAssociations(Set<Association> associations) {
        this.associations = associations;
    }

    public synchronized void addAssociation(Association assoc) {
        assoc.setGene_product(this);
        if (this.associations == null) {
            this.associations = new HashSet<Association>();
        }
        this.associations.add(assoc);
    }

    public Association findAssociation(Term term, String source) {
        Association found = null;
        Iterator<Association> it = this.associations.iterator();
        while (it.hasNext() && found == null) {
            Association a = it.next();
            if (a.getTerm() != term || !a.getSource_db().getName().equals(source)) continue;
            found = a;
        }
        return found;
    }

    public synchronized Association removeAssociation(Term term, String source) {
        Association removal = this.findAssociation(term, source);
        if (removal != null) {
            int size = this.associations.size();
            this.associations.remove(removal);
            if (this.associations.size() == size) {
                System.out.println("Unable to remove " + term + " from associations for " + this.dbxref.getDb_name() + ":" + this.dbxref.getDbxref_id());
            }
        }
        return removal;
    }

    public synchronized Association removeAssociation(Association a) {
        System.out.println("1. Associations contains " + this.associations.contains(a));
        if (this.associations.remove(a)) {
            System.out.println("Yippee! removed ");
            System.out.println("Associations contains " + this.associations.contains(a));
            return a;
        }
        System.out.println("Unable to remove");
        System.out.println("2. Associations contains " + this.associations.contains(a));
        return null;
    }
}

