/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.db.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.geneontology.db.model.Association;
import org.geneontology.db.model.GOModel;
import org.geneontology.db.model.MetaRelationship;
import org.geneontology.db.model.Relationship;
import org.geneontology.db.model.TermDBXref;
import org.geneontology.db.model.TermDefinition;
import org.geneontology.db.model.TermSynonym;

public class Term
extends GOModel {
    protected int term_id;
    protected String acc;
    protected String name;
    protected String cv;
    protected Integer is_root;
    protected Integer is_obsolete;
    protected TermDefinition term_definition;
    protected Set<Relationship> parents;
    protected Set<Relationship> children;
    protected Set<TermSynonym> synonyms;
    protected Set<TermDBXref> termDBXrefs;
    protected Set<Term> subsets;
    protected Set<MetaRelationship> considerations;
    protected Set<Association> associations;
    protected String source;
    private long timestamp;

    public Term() {
        String[] uniqueConstraintFields = new String[]{"acc"};
        this.initUniqueConstraintFields(Term.class, uniqueConstraintFields);
    }

    public void setCv(String cv) {
        this.cv = cv;
    }

    public String getCv() {
        return this.cv;
    }

    public Integer getIs_root() {
        return this.is_root;
    }

    public void setIs_root(Integer is_root) {
        this.is_root = is_root;
    }

    public String getAcc() {
        return this.acc;
    }

    public void setAcc(String acc) {
        this.acc = acc;
    }

    public TermDefinition getTerm_definition() {
        return this.term_definition;
    }

    public void setTerm_definition(TermDefinition term_definition) {
        this.term_definition = term_definition;
    }

    public String getDefinition() {
        return this.term_definition != null ? this.term_definition.getTerm_definition() : null;
    }

    public void setDefinition(String definition) {
        if (this.term_definition == null) {
            this.term_definition = new TermDefinition();
        }
        this.term_definition.setTerm_id(this.term_id);
        this.term_definition.setTerm_definition(definition);
    }

    public int getTerm_id() {
        return this.term_id;
    }

    public void setTerm_id(int term_id) {
        this.term_id = term_id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getIs_obsolete() {
        return this.is_obsolete;
    }

    public boolean isObsolete() {
        return this.is_obsolete != 0;
    }

    public void setIs_obsolete(Integer is_obsolete) {
        this.is_obsolete = is_obsolete;
    }

    public String toString() {
        return this.acc + " " + (this.name != null ? this.name : "");
    }

    public Set<TermSynonym> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(Set<TermSynonym> synonyms) {
        this.synonyms = synonyms;
    }

    public TermSynonym getSynonym() {
        return this.synonyms != null ? (TermSynonym)((Object)this.synonyms.iterator()) : null;
    }

    public void setDbxref(TermSynonym synonym) {
        if (this.synonyms == null) {
            this.synonyms = new HashSet<TermSynonym>(2);
        }
        this.synonyms.add(synonym);
    }

    public Set<Relationship> getParents() {
        return this.parents;
    }

    public void setParents(Set<Relationship> parents) {
        this.parents = parents;
    }

    public Set<Relationship> getChildren() {
        return this.children;
    }

    public void setChildren(Set<Relationship> children) {
        this.children = children;
    }

    public Set<TermDBXref> getTermDBXrefs() {
        return this.termDBXrefs;
    }

    public void setTermDBXrefs(Set<TermDBXref> termDBXrefs) {
        this.termDBXrefs = termDBXrefs;
    }

    public Set<Term> getSubsets() {
        return this.subsets;
    }

    public void setSubsets(Set<Term> subsets) {
        this.subsets = subsets;
    }

    public Set<MetaRelationship> getConsiderations() {
        return this.considerations;
    }

    public void setConsiderations(Set<MetaRelationship> considerations) {
        this.considerations = considerations;
    }

    public Set<Association> getAssociations() {
        return this.associations;
    }

    public void setAssociations(Set<Association> associations) {
        this.associations = associations;
    }

    public boolean isParentOf(Term child) {
        if (this.getAcc().equals(child.getAcc())) {
            return false;
        }
        boolean is_child = false;
        Iterator<Relationship> it = this.children.iterator();
        while (it.hasNext() && !is_child) {
            Relationship relate = it.next();
            Term check = relate.getSubject();
            is_child = check.getAcc().equals(child.getAcc());
            if (is_child) continue;
            is_child = check.isParentOf(child);
        }
        return is_child;
    }

    public boolean isRoot() {
        return this.is_root == 1;
    }

    public String getSource() {
        if (this.isRoot()) {
            return this.source;
        }
        return null;
    }

    public void setSource(String source) {
        if (this.isRoot()) {
            this.source = source;
        }
    }

    public long getTimestamp() {
        if (this.isRoot()) {
            return this.timestamp;
        }
        return 0L;
    }

    public void setTimestamp(long timestamp) {
        if (this.isRoot()) {
            this.timestamp = timestamp;
        }
    }
}

