/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.db.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.geneontology.db.factory.GOobjectFactory;
import org.geneontology.db.model.Association;
import org.geneontology.db.model.DB;
import org.geneontology.db.model.DBXref;
import org.geneontology.db.model.Evidence;
import org.geneontology.db.model.GeneProduct;
import org.geneontology.db.model.Term;
import org.hibernate.Session;

public class GHOUL_DeleteTest
extends TestCase {
    private GOobjectFactory factory;
    public static final String REFGENOME = "RefGenome";
    public static final String DESCENDANT_SEQUENCES_EC = "IBD";
    public static final String ANCESTRAL_EVIDENCE_CODE = "IBA";
    public static final String PAINT_DB = "PANTHER";
    private static DBXref paint_dbxref;
    protected static final Logger logger;

    public GHOUL_DeleteTest() {
        try {
            this.factory = new GOobjectFactory("hibernate.cfg.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Session startSession() {
        Session session = this.factory.startSession();
        return session;
    }

    public void endSession(Session session) {
        if (session != null) {
            session.close();
        }
    }

    public void testDeleteAssoc() {
        Session session = this.startSession();
        GeneProduct gene_product = this.factory.getGPByDBXref("RGD", "1308764", session);
        Assert.assertTrue((gene_product != null ? 1 : 0) != 0);
        Term term = this.factory.getTermByAcc("GO:0000011", session);
        Assert.assertTrue((term != null ? 1 : 0) != 0);
        this.endSession(session);
        if (term != null && gene_product != null) {
            Association new_assoc = this.createAssociation(term, new Integer(9042012), false);
            gene_product.addAssociation(new_assoc);
            Association removed = gene_product.removeAssociation(term, REFGENOME);
            Assert.assertTrue((removed != null ? 1 : 0) != 0);
        }
    }

    private Association createAssociation(Term term, Integer date, boolean MRC) {
        Association assoc = new Association();
        assoc.setTerm(term);
        if (date == null) {
            assoc.setDate();
        } else {
            assoc.setDate(date);
        }
        DB db = new DB();
        db.setName(REFGENOME);
        assoc.setSource_db(db);
        String code = ANCESTRAL_EVIDENCE_CODE;
        assoc.addEvidence(this.createEvidence(term, code));
        assoc.setDirectMRC(MRC);
        assoc.setDirectNot(false);
        return assoc;
    }

    private Evidence createEvidence(Term term, String code) {
        Evidence evidence = new Evidence();
        evidence.setCode(code);
        evidence.setDbxref(this.getPAINTEvidenceDBXref());
        return evidence;
    }

    public DBXref getPAINTEvidenceDBXref() {
        if (paint_dbxref == null) {
            paint_dbxref = new DBXref();
            paint_dbxref.setDb_name(PAINT_DB);
            paint_dbxref.setKeytype("Personal Communication");
            paint_dbxref.setDescription("PAINT protein family curation");
            paint_dbxref.setFor_definition(false);
        }
        paint_dbxref.setAccession("DEL_TEST1");
        return paint_dbxref;
    }

    static {
        logger = Logger.getLogger(GHOUL_DeleteTest.class);
    }
}

