/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.db.test;

import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.geneontology.db.factory.GOobjectFactory;
import org.geneontology.db.model.Association;
import org.geneontology.db.model.DB;
import org.geneontology.db.model.DBXref;
import org.geneontology.db.model.Evidence;
import org.geneontology.db.model.GOModel;
import org.geneontology.db.model.GeneProduct;
import org.geneontology.db.model.GraphPath;
import org.geneontology.db.model.HomolSet;
import org.geneontology.db.model.MetaRelationship;
import org.geneontology.db.model.ProductSeq;
import org.geneontology.db.model.Relationship;
import org.geneontology.db.model.Sequence;
import org.geneontology.db.model.Species;
import org.geneontology.db.model.Term;
import org.geneontology.db.model.TermDBXref;
import org.geneontology.db.model.TermSynonym;
import org.hibernate.Session;

public class GHOUL_UnitTest
extends TestCase {
    private GOobjectFactory factory;
    protected static final Logger logger = Logger.getLogger(GHOUL_UnitTest.class);

    public GHOUL_UnitTest() {
        try {
            this.factory = new GOobjectFactory("hibernate.cfg.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Session startSession() {
        Session session = this.factory.startSession();
        return session;
    }

    public void endSession(Session session) {
        if (session != null) {
            session.close();
        }
    }

    public void testGraphPath() {
        Session session = this.startSession();
        GraphPath path = this.factory.getPath(12749, 7072, session);
        Assert.assertTrue((path != null ? 1 : 0) != 0);
        this.endSession(session);
    }

    public void testGP() {
        Session session = this.startSession();
        GeneProduct gp = this.factory.getGPByDBXrefStr("ZFIN:ZDB-GENE-030318-3", session);
        Assert.assertTrue((gp != null ? 1 : 0) != 0);
        if (gp != null) {
            logger.assertLog(gp.getSymbol().equals("myo6b"), "Symbol does not match myo6b");
            Assert.assertEquals((String)gp.getSymbol(), (String)"myo6b");
            logger.assertLog(gp.getFull_name().equals("myosin VIb"), "Fullname does not match myosin VIb");
            Assert.assertEquals((String)gp.getFull_name(), (String)"myosin VIb");
            logger.assertLog(gp.getDbxref().getDb_name().equals("ZFIN"), "DB does not match ZFIN");
            Assert.assertEquals((String)gp.getDbxref().getDb_name(), (String)"ZFIN");
            logger.assertLog(gp.getDbxref().getAccession().equals("ZDB-GENE-030318-3"), "UID does not match ZDB-GENE-030318-3");
            Assert.assertEquals((String)gp.getDbxref().getAccession(), (String)"ZDB-GENE-030318-3");
            logger.assertLog(gp.getSpecies().getNcbi_taxa_id() == 7955, "taxa_id does not match 7955");
            Assert.assertEquals((int)gp.getSpecies().getNcbi_taxa_id(), (int)7955);
            logger.assertLog(gp.getSpecies().getCommon_name().equals("zebrafish"), "Common name does not match zebrafish");
            Assert.assertEquals((String)gp.getSpecies().getCommon_name(), (String)"zebrafish");
            logger.assertLog(gp.getSpecies().getGenus().equals("Danio"), "Genus name does not match Danio");
            Assert.assertEquals((String)gp.getSpecies().getGenus(), (String)"Danio");
            logger.assertLog(gp.getSpecies().getSpecies().equals("rerio"), "species name does not match rerio");
            Assert.assertEquals((String)gp.getSpecies().getSpecies(), (String)"rerio");
            logger.info((Object)("\n" + this.prettyPrint(gp)));
            gp = this.factory.getGPByDBXref("RGD", "Q5M819", session);
            Assert.assertTrue((gp != null ? 1 : 0) != 0);
            Iterator<Association> it = this.factory.getAssociationsIteratorByGP(gp, session);
            Assert.assertTrue((boolean)it.hasNext());
            while (it.hasNext()) {
                Association assoc = it.next();
                logger.info((Object)(" assoc: " + assoc));
            }
        }
        this.endSession(session);
    }

    public void testGPJoin() {
        Session session = this.startSession();
        GeneProduct gp = this.factory.getGPByDBXref("RGD", "Q5M819", session);
        Assert.assertTrue((gp != null ? 1 : 0) != 0);
        if (gp == null) {
            gp = (GeneProduct)((Object)this.factory.getGPByName("Psph", session));
            Assert.assertTrue((gp != null ? 1 : 0) != 0);
        }
        this.endSession(session);
        logger.info((Object)this.prettyPrint(gp));
    }

    public void testObsolete() {
        Session session = this.startSession();
        Term term = this.factory.getTermByAcc("GO:0000005", session);
        Assert.assertTrue((term != null ? 1 : 0) != 0);
        if (term != null) {
            logger.info((Object)("\n\t" + this.prettyPrint(term)));
        }
        this.endSession(session);
        Assert.assertTrue((boolean)term.isObsolete());
    }

    public void testTerm() {
        Session session = this.startSession();
        Term term = this.factory.getTermByAcc("GO:0000011", session);
        Assert.assertTrue((term != null ? 1 : 0) != 0);
        if (term != null) {
            for (Association a : term.getAssociations()) {
                logger.assertLog(a.getSource_db().getName() != null, term.getAcc() + " has association (id=" + a.getAssoc_id() + ") with source_db_id null");
                Assert.assertTrue((String)(term.getAcc() + " has association with source_db_id null"), (a.getSource_db().getName() != null ? 1 : 0) != 0);
            }
            logger.info((Object)("\n\t" + this.prettyPrint(term)));
        }
        this.endSession(session);
    }

    public void testTermParents() {
        Vector<String> gp_list = new Vector<String>();
        gp_list.add("MGI:98358");
        gp_list.add("3735");
        gp_list.add("ZDB-GENE-011207-1");
        Session session = this.startSession();
        Vector<Term> terms = this.factory.getTermIntersectionByGP(gp_list, session);
        if (terms != null) {
            for (Term a : terms) {
                logger.assertLog(a.getAcc() != null, "id=" + a.getAcc() + " is named " + a.getName());
                Assert.assertTrue((String)(a.getAcc() + " has name "), (a.getName() != null ? 1 : 0) != 0);
            }
        }
        this.endSession(session);
    }

    private GeneProduct testGetGP_byName() {
        Session session = this.startSession();
        Iterator<GeneProduct> gps = this.factory.getGPByName("clock", session);
        GeneProduct found = null;
        while (gps.hasNext() && found == null) {
            GeneProduct gp = gps.next();
            found = gp.getGp_id() == 244529 ? gp : null;
        }
        this.endSession(session);
        Assert.assertTrue((found != null ? 1 : 0) != 0);
        return found;
    }

    public void testAssocQualifier() {
        GeneProduct gp = this.testGetGP_byName();
        boolean found = false;
        System.out.println("symbol = " + gp.getSymbol());
        Set<Association> assoc = gp.getAssociations();
        for (Association a : assoc) {
            System.out.println("association id = " + a.getAssoc_id());
            Set<Term> quals = a.getQualifiers();
            for (Term term : quals) {
                System.out.println("qualifier = " + term.getName());
                found = true;
            }
        }
        Assert.assertTrue((boolean)found);
    }

    public void prettyPrint(GOModel model) {
        Assert.assertTrue((model != null ? 1 : 0) != 0);
        logger.info((Object)model);
    }

    public String prettyPrint(GeneProduct gp) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GENEP:\t" + gp.getSymbol() + " (" + gp.getFull_name() + ")\t" + gp.getDbxref().getDb_name() + this.validDBName(gp.getDbxref().getDb_name()) + ":" + gp.getDbxref().getAccession() + "\t" + this.getString(gp.getSpecies()) + "\tSO-type=" + gp.getSO_type().getName() + "\n");
        for (String string : gp.getSynonyms()) {
            buffer.append("\tSYN:\t" + string + "\n");
        }
        for (Association association : gp.getAssociations()) {
            this.prettyPrint(association, buffer);
        }
        this.prettyPrint(gp.getHomol_set(), buffer);
        for (ProductSeq productSeq : gp.getSeqs()) {
            this.prettyPrint(productSeq.getSeq(), buffer);
        }
        return buffer.toString();
    }

    public String getString(Species sp) {
        if (sp == null) {
            return "species=null";
        }
        return sp.getGenus() + " " + sp.getSpecies();
    }

    public String prettyPrint(Sequence s, StringBuffer buffer) {
        buffer.append("\tSEQ:\t" + s.getName() + "\t(lastmodified=" + s.getTimelastmodified() + ")");
        buffer.append("\tmoltype=" + s.getMoltype() + "\tdescription=" + s.getDescription());
        buffer.append("\tlen=" + s.getSeq_len() + "\n");
        for (DBXref x : s.getDbxrefs()) {
            this.prettyPrint(x, buffer, "\tSEQ_XREF:");
        }
        buffer.append("\n");
        return buffer.toString();
    }

    protected String prettyPrint(Term term) {
        StringBuffer buffer = new StringBuffer();
        return this.prettyPrint(term, buffer);
    }

    public String prettyPrint(Term term, StringBuffer buffer) {
        buffer.append("TERM:\tCV=" + term.getCv() + "\tuid=" + term.getAcc() + "\tname=" + term.getName() + "\tobsolete=" + term.getIs_obsolete() + "\tis_root=" + term.getIs_root() + "\n");
        buffer.append("\tTERM_DEF: " + term.getDefinition() + "\n");
        for (TermDBXref x : term.getTermDBXrefs()) {
            if (x.getIs_for_definition() == 1) {
                this.prettyPrint(x.getDbxref(), buffer, "\tDEF_XREF");
                continue;
            }
            this.prettyPrint(x.getDbxref(), buffer, "\tTERM_XREF");
        }
        this.prettyPrintSyns(term, buffer);
        for (Association a : term.getAssociations()) {
            this.prettyPrint(a, buffer);
        }
        this.prettyPrintParents(term.getParents(), buffer);
        this.prettyPrintChildren(term.getChildren(), buffer);
        this.prettyPrintSubsets(term.getSubsets(), buffer);
        this.prettyPrintConsiderations(term.getConsiderations(), buffer);
        return buffer.toString();
    }

    protected void prettyPrintParents(Set<Relationship> rels, StringBuffer buffer) {
        for (Relationship r : rels) {
            buffer.append("\tPARENT:\t" + r.getType().getName() + "\t" + r.getObject().getName() + "\n");
        }
    }

    protected void prettyPrintChildren(Set<Relationship> rels, StringBuffer buffer) {
        for (Relationship r : rels) {
            buffer.append("\tCHILD:\t" + r.getType().getName() + "\t" + r.getSubject().getName() + "\n");
        }
    }

    protected void prettyPrintSubsets(Set<Term> slims, StringBuffer buffer) {
        for (Term t : slims) {
            buffer.append("SUBSET:\t" + t.getName());
        }
        buffer.append("\n");
    }

    protected String prettyPrint(DBXref dbx, StringBuffer buffer, String tag) {
        if (dbx == null) {
            buffer.append(tag + "\tNo homolset" + "\n");
        } else {
            buffer.append(tag + "\t" + dbx.getDb_name() + this.validDBName(dbx.getDb_name()) + ":" + dbx.getAccession() + "\tdesc=" + dbx.getDescription() + "\tkeytype=" + dbx.getKeytype() + "\n");
        }
        return buffer.toString();
    }

    private String validDBName(String db_name) {
        Session session = this.startSession();
        DB db = this.factory.getDBByName(db_name, session);
        this.endSession(session);
        return db == null ? "(not in db table)" : "";
    }

    protected String prettyPrintSyns(Term term, StringBuffer buffer) {
        for (TermSynonym tsyn : term.getSynonyms()) {
            buffer.append("\tSYN:\t" + tsyn.getSynonym() + "\ttype=" + tsyn.getSynonymType().getName() + "\tcategory=" + tsyn.getSynonymCategory() + "\talt_id=" + tsyn.getAlternateAcc() + "\n");
        }
        return buffer.toString();
    }

    protected void prettyPrintConsiderations(Set<MetaRelationship> metas, StringBuffer buffer) {
        for (MetaRelationship r : metas) {
            buffer.append("META:\t" + r.getType().getAcc() + "\t" + r.getObject().getName());
        }
    }

    protected String prettyPrint(HomolSet homol_set, StringBuffer buffer) {
        if (homol_set == null) {
            buffer.append("No homolset");
        } else {
            GeneProduct gp = homol_set.getTarget_gp();
            Term term = homol_set.getTerm();
            buffer.append("\tHOMOL:\t" + homol_set.getSymbol() + "\tdescription=" + homol_set.getDescription() + "\t" + this.getString(homol_set.getSpecies()) + "\t" + (gp == null ? "gp=null" : "gp=" + gp.getSymbol()) + "\t" + (term == null ? "term=null" : "term=" + term.getName()) + "\n");
            this.prettyPrint(homol_set.getDbxref(), buffer, "\tHOMOL-XREF:");
            buffer.append("\tHOMOL_GENES:\t");
            for (GeneProduct member : homol_set.getGenes()) {
                buffer.append(member.getSymbol() + "\t");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    protected void prettyPrint(Association assoc, StringBuffer buffer) {
        if (assoc == null) {
            Assert.assertNotNull((String)"Gene product without associations", (Object)assoc);
            logger.info((Object)"Association is null");
            buffer.append("\tASSOC:\tnone\n");
        } else {
            buffer.append("\tASSOC:\tgp=" + assoc.getGene_product().getSymbol() + "\tterm=" + assoc.getTerm().getName() + (assoc.getIs_not() == null ? "\t" : (assoc.getIs_not() == 0 ? "\t" : "\tNOT")) + (assoc.getSource_db() == null ? "\tsource=null" : assoc.getSource_db().getName()) + "\tdate=" + assoc.getDate());
            for (Evidence e : assoc.getEvidence()) {
                this.prettyPrint(e, buffer);
            }
        }
    }

    protected void prettyPrint(Evidence e, StringBuffer buffer) {
        buffer.append("\n\t\tEVIDENCE:\t" + e.getCode() + "\txref=" + e.getDbxref().getDb_name() + ":" + e.getDbxref().getAccession());
        for (DBXref x : e.getWiths()) {
            buffer.append("\tWith=" + x.getDb_name() + ":" + x.getAccession());
        }
        buffer.append("\n");
    }
}

